/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.registry.NetherBlocks;

public class BlockMushroomFir
extends BlockBaseNotFull
implements BehaviourWood {
    public static final EnumProperty<MushroomFirShape> SHAPE = EnumProperty.m_61587_((String)"shape", MushroomFirShape.class);
    private static final VoxelShape BOTTOM_SHAPE = BlockMushroomFir.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = BlockMushroomFir.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TOP_SHAPE = BlockMushroomFir.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SIDE_BIG_SHAPE = BlockMushroomFir.m_49796_((double)0.01, (double)0.01, (double)0.01, (double)15.99, (double)13.0, (double)15.99);
    private static final VoxelShape SIDE_SMALL_N_SHAPE = BlockMushroomFir.m_49796_((double)4.0, (double)1.0, (double)0.0, (double)12.0, (double)8.0, (double)8.0);
    private static final VoxelShape SIDE_SMALL_S_SHAPE = BlockMushroomFir.m_49796_((double)4.0, (double)1.0, (double)8.0, (double)12.0, (double)8.0, (double)16.0);
    private static final VoxelShape SIDE_SMALL_E_SHAPE = BlockMushroomFir.m_49796_((double)8.0, (double)1.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0);
    private static final VoxelShape SIDE_SMALL_W_SHAPE = BlockMushroomFir.m_49796_((double)0.0, (double)1.0, (double)4.0, (double)8.0, (double)8.0, (double)12.0);
    private static final VoxelShape END_SHAPE = BlockMushroomFir.m_49796_((double)0.01, (double)0.0, (double)0.01, (double)15.99, (double)15.99, (double)15.99);

    public BlockMushroomFir() {
        super(Materials.makeNetherWood(MapColor.f_283772_).m_60955_());
        this.setDropItself(false);
        this.setRenderLayer(BNRenderLayer.CUTOUT);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{SHAPE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        switch ((MushroomFirShape)((Object)state.m_61143_(SHAPE))) {
            case BOTTOM: {
                return BOTTOM_SHAPE;
            }
            case END: {
                return END_SHAPE;
            }
            default: {
                return MIDDLE_SHAPE;
            }
            case SIDE_BIG_E: 
            case SIDE_BIG_N: 
            case SIDE_BIG_S: 
            case SIDE_BIG_W: {
                return SIDE_BIG_SHAPE;
            }
            case SIDE_SMALL_E: {
                return SIDE_SMALL_E_SHAPE;
            }
            case SIDE_SMALL_N: {
                return SIDE_SMALL_N_SHAPE;
            }
            case SIDE_SMALL_S: {
                return SIDE_SMALL_S_SHAPE;
            }
            case SIDE_SMALL_W: {
                return SIDE_SMALL_W_SHAPE;
            }
            case TOP: 
        }
        return TOP_SHAPE;
    }

    @Environment(value=EnvType.CLIENT)
    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        MushroomFirShape shape = (MushroomFirShape)((Object)state.m_61143_(SHAPE));
        return shape == MushroomFirShape.BOTTOM || shape == MushroomFirShape.MIDDLE ? new ItemStack((ItemLike)NetherBlocks.MAT_MUSHROOM_FIR.getStem()) : new ItemStack((ItemLike)NetherBlocks.MAT_MUSHROOM_FIR.getSapling());
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Comparable _shape = (Comparable)state.m_61148_().get(SHAPE);
        if (_shape == null) {
            return false;
        }
        MushroomFirShape shape = (MushroomFirShape)((Object)SHAPE.m_61709_().cast(_shape));
        if (shape == MushroomFirShape.SIDE_BIG_N || shape == MushroomFirShape.SIDE_SMALL_N) {
            return world.m_8055_(pos.m_122012_()).m_60734_() == this;
        }
        if (shape == MushroomFirShape.SIDE_BIG_S || shape == MushroomFirShape.SIDE_SMALL_S) {
            return world.m_8055_(pos.m_122019_()).m_60734_() == this;
        }
        if (shape == MushroomFirShape.SIDE_BIG_E || shape == MushroomFirShape.SIDE_SMALL_E) {
            return world.m_8055_(pos.m_122029_()).m_60734_() == this;
        }
        if (shape == MushroomFirShape.SIDE_BIG_W || shape == MushroomFirShape.SIDE_SMALL_W) {
            return world.m_8055_(pos.m_122024_()).m_60734_() == this;
        }
        BlockState down = world.m_8055_(pos.m_7495_());
        return down.m_60734_() == this || down.m_60783_((BlockGetter)world, pos.m_7495_(), Direction.UP);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.m_7898_(state, (LevelReader)world, pos) ? state : Blocks.f_50016_.m_49966_();
    }

    public static enum MushroomFirShape implements StringRepresentable
    {
        BOTTOM("bottom"),
        MIDDLE("middle"),
        TOP("top"),
        SIDE_BIG_N("side_big_n"),
        SIDE_BIG_S("side_big_s"),
        SIDE_BIG_E("side_big_e"),
        SIDE_BIG_W("side_big_w"),
        SIDE_SMALL_N("side_small_n"),
        SIDE_SMALL_S("side_small_s"),
        SIDE_SMALL_E("side_small_e"),
        SIDE_SMALL_W("side_small_w"),
        END("end");

        final String name;

        private MushroomFirShape(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

